/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.notifier;

import com.relaxed.common.exception.domain.ExceptionMessage;
import com.relaxed.common.exception.domain.ExceptionNoticeResult;
import com.relaxed.common.exception.notifier.AbstractExceptionNotifier;
import com.relaxed.extend.dingtalk.message.DingTalkMessage;
import com.relaxed.extend.dingtalk.message.DingTalkTextMessage;
import com.relaxed.extend.dingtalk.request.DingTalkResponse;
import com.relaxed.extend.dingtalk.request.DingTalkSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkGlobalExceptionNotifier
extends AbstractExceptionNotifier {
    private static final Logger log = LoggerFactory.getLogger(DingTalkGlobalExceptionNotifier.class);
    private final DingTalkSender sender;

    public DingTalkGlobalExceptionNotifier(String channel, String applicationName, DingTalkSender sender) {
        super(channel, applicationName);
        this.sender = sender;
    }

    @Override
    public ExceptionNoticeResult send(ExceptionMessage sendMessage) {
        DingTalkResponse response = this.sender.sendMessage((DingTalkMessage)new DingTalkTextMessage().setContent(sendMessage.toString()).atAll());
        return new ExceptionNoticeResult().setChannel(this.channel).setSuccess(response.isSuccess()).setErrMsg(response.getResponse());
    }

    public DingTalkSender getSender() {
        return this.sender;
    }
}

