/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.holder;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.relaxed.common.exception.domain.ExceptionMessage;
import com.relaxed.common.exception.domain.ExceptionNoticeResponse;
import com.relaxed.common.exception.domain.ExceptionNoticeResult;
import com.relaxed.common.exception.notifier.ExceptionNotifier;
import com.relaxed.common.exception.notifier.NoticeResultDecision;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExceptionNotifierHolder {
    private static final Logger log = LoggerFactory.getLogger(ExceptionNotifierHolder.class);
    private final List<ExceptionNotifier> notifiers;
    private final NoticeResultDecision decision;
    private final Integer notifierCount;

    public ExceptionNotifierHolder(List<ExceptionNotifier> notifiers, NoticeResultDecision decision) {
        Assert.notEmpty(notifiers, (String)"At least one Notifier");
        this.notifiers = notifiers;
        this.notifierCount = notifiers.size();
        this.decision = decision;
    }

    public ExceptionNoticeResponse notice(ExceptionMessage exceptionMessage) {
        ExceptionNoticeResponse noticeResponse = new ExceptionNoticeResponse();
        ArrayList<ExceptionNoticeResult> noticeResults = new ArrayList<ExceptionNoticeResult>();
        for (ExceptionNotifier notifier : this.notifiers) {
            String noticeType = notifier.getChannel();
            try {
                ExceptionNoticeResult noticeResult = notifier.send(exceptionMessage);
                noticeResults.add(noticeResult);
            }
            catch (Exception e) {
                log.error("\u5f02\u5e38\u901a\u77e5\u5668{},\u901a\u77e5\u5931\u8d25", (Object)noticeType, (Object)e);
                noticeResults.add(ExceptionNoticeResult.ofFail(noticeType, ExceptionUtil.getMessage((Throwable)e)));
            }
        }
        noticeResponse.setNotifierCount(this.notifierCount);
        noticeResponse.setNoticeResults(noticeResults);
        noticeResponse.setSuccess(this.decision.decide(noticeResults));
        return noticeResponse;
    }
}

