/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.holder;

import org.springframework.util.StringUtils;

public class ExceptionHolder {
    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal();

    private ExceptionHolder() {
    }

    public static String getXID() {
        String xid = CONTEXT_HOLDER.get();
        return StringUtils.hasText((String)xid) ? xid : null;
    }

    public static String unbind(String xid) {
        CONTEXT_HOLDER.remove();
        return xid;
    }

    public static String bind(String xid) {
        CONTEXT_HOLDER.set(xid);
        return xid;
    }

    public static void remove() {
        CONTEXT_HOLDER.remove();
    }
}

