/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.aop;

import cn.hutool.core.util.IdUtil;
import com.relaxed.common.exception.handler.GlobalExceptionHandler;
import com.relaxed.common.exception.holder.ExceptionHolder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExceptionAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAnnotationInterceptor.class);
    private final GlobalExceptionHandler globalExceptionHandler;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        if (StringUtils.hasText((String)ExceptionHolder.getXID())) {
            return invocation.proceed();
        }
        String xid = IdUtil.simpleUUID();
        ExceptionHolder.bind(xid);
        try {
            result = invocation.proceed();
        }
        catch (Throwable throwable) {
            this.globalExceptionHandler.handle(throwable);
            throw throwable;
        }
        finally {
            ExceptionHolder.unbind(xid);
        }
        return result;
    }

    public ExceptionAnnotationInterceptor(GlobalExceptionHandler globalExceptionHandler) {
        this.globalExceptionHandler = globalExceptionHandler;
    }
}

