/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public class AnnotationMethodPoint
implements Pointcut {
    private final Class<? extends Annotation> annotationType;

    public AnnotationMethodPoint(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        this.annotationType = annotationType;
    }

    public ClassFilter getClassFilter() {
        return ClassFilter.TRUE;
    }

    public MethodMatcher getMethodMatcher() {
        return new AnnotationMethodMatcher(this.annotationType);
    }

    private static class AnnotationMethodMatcher
    extends StaticMethodMatcher {
        private final Class<? extends Annotation> annotationType;

        public AnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean matches(Method method, Class<?> targetClass) {
            if (this.matchesMethod(method)) {
                return true;
            }
            if (Proxy.isProxyClass(targetClass)) {
                return false;
            }
            Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
            return specificMethod != method && this.matchesMethod(specificMethod);
        }

        private boolean matchesMethod(Method method) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, this.annotationType);
        }
    }
}

