/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception;

import com.relaxed.common.exception.aop.DefaultPointCutBuilder;
import com.relaxed.common.exception.aop.ExceptionAdvisorRegister;
import com.relaxed.common.exception.aop.ExceptionAnnotationAdvisor;
import com.relaxed.common.exception.aop.ExceptionAnnotationInterceptor;
import com.relaxed.common.exception.aop.PointCutBuilder;
import com.relaxed.common.exception.handler.GlobalExceptionHandler;
import org.aopalliance.aop.Advice;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration(proxyBeanMethods=false)
public class ExceptionAopAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PointCutBuilder pointCutBuilder() {
        return new DefaultPointCutBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionAdvisorRegister exceptionAdvisorRegister(PointCutBuilder pointCutBuilder, ExceptionAnnotationInterceptor exceptionAnnotationInterceptor) {
        return new ExceptionAdvisorRegister(pointCutBuilder.build(), (Advice)exceptionAnnotationInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionAnnotationInterceptor exceptionAnnotationInterceptor(GlobalExceptionHandler globalExceptionHandler) {
        return new ExceptionAnnotationInterceptor(globalExceptionHandler);
    }

    @Role(value=2)
    @Bean
    @ConditionalOnMissingBean
    public ExceptionAnnotationAdvisor exceptionAnnotationAdvisor(ExceptionAdvisorRegister exceptionAdvisorRegister) {
        ExceptionAnnotationAdvisor advisor = new ExceptionAnnotationAdvisor(exceptionAdvisorRegister);
        advisor.setOrder(exceptionAdvisorRegister.getOrder());
        return advisor;
    }
}

