/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.util;

import cn.hutool.core.util.StrUtil;
import com.relaxed.common.core.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    public static String getGrantType() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String grantType = request.getParameter("grant_type");
        return grantType;
    }

    public static String getOAuth2ClientId() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String clientId = request.getParameter("client_id");
        if (StrUtil.isNotBlank((CharSequence)clientId)) {
            return clientId;
        }
        String basic = request.getHeader("Authorization");
        if (StrUtil.isNotBlank((CharSequence)basic) && basic.startsWith("Basic ")) {
            basic = basic.replace("Basic ", "");
            String basicPlainText = new String(Base64.getDecoder().decode(basic.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            clientId = basicPlainText.split(":")[0];
        }
        return clientId;
    }

    public static String getRequestRefreshToken() {
        String refreshToken = WebUtils.getParameter((String)"refresh_token");
        return refreshToken;
    }
}

