/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.util;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.relaxed.oauth2.auth.handler.AuthorizationInfoHandle;
import com.relaxed.oauth2.auth.util.ClassUtil;
import com.relaxed.oauth2.auth.util.RequestUtil;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.security.core.userdetails.UserDetailsService;

public class PreMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PreMethodInterceptor.class);
    private final AuthorizationInfoHandle authorizationInfoHandle;

    public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object result;
        String oAuth2ClientId = RequestUtil.getOAuth2ClientId();
        if (StrUtil.isEmpty((CharSequence)oAuth2ClientId)) {
            return methodProxy.invokeSuper(o, args);
        }
        String methodName = method.getName();
        UserDetailsService customService = this.authorizationInfoHandle.obtainClient(oAuth2ClientId);
        if (customService != null) {
            try {
                Method customMethod = ClassUtil.getMethod(customService.getClass(), methodName, args);
                result = customMethod.invoke((Object)customService, args);
            }
            catch (Exception e) {
                throw ExceptionUtil.unwrap((Throwable)e);
            }
        } else {
            result = methodProxy.invokeSuper(o, args);
        }
        return result;
    }

    public PreMethodInterceptor(AuthorizationInfoHandle authorizationInfoHandle) {
        this.authorizationInfoHandle = authorizationInfoHandle;
    }
}

