/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.handler;

import com.relaxed.oauth2.auth.functions.RetriveUserFunction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.userdetails.UserDetailsService;

public class AuthorizationInfoHandle {
    private Map<String, UserDetailsService> CLIENT_USER_HOLDER = new ConcurrentHashMap<String, UserDetailsService>();
    private Map<String, RetriveUserFunction> GRANT_TYPE_HANDLE_HOLDER = new ConcurrentHashMap<String, RetriveUserFunction>();

    public AuthorizationInfoHandle client(String clientId, UserDetailsService userDetailsService) {
        this.CLIENT_USER_HOLDER.put(clientId, userDetailsService);
        return this;
    }

    public AuthorizationInfoHandle client(Map<String, UserDetailsService> clientMap) {
        this.CLIENT_USER_HOLDER.putAll(clientMap);
        return this;
    }

    public AuthorizationInfoHandle grantType(String grantType, RetriveUserFunction retriveUserFunction) {
        this.GRANT_TYPE_HANDLE_HOLDER.put(grantType, retriveUserFunction);
        return this;
    }

    public AuthorizationInfoHandle grantType(Map<String, RetriveUserFunction> grantTypeMap) {
        this.GRANT_TYPE_HANDLE_HOLDER.putAll(grantTypeMap);
        return this;
    }

    public RetriveUserFunction obtainFunction(String grantType) {
        return this.GRANT_TYPE_HANDLE_HOLDER.get(grantType);
    }

    public UserDetailsService obtainClient(String clientId) {
        return this.CLIENT_USER_HOLDER.get(clientId);
    }
}

