/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.extension.refresh;

import com.relaxed.oauth2.auth.functions.RetriveUserFunction;
import com.relaxed.oauth2.auth.handler.AuthorizationInfoHandle;
import com.relaxed.oauth2.auth.util.RequestUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

public class CustomPreAuthenticatedUserDetailsService<T extends Authentication>
implements AuthenticationUserDetailsService<T>,
InitializingBean {
    private UserDetailsService userDetailsService;
    private AuthorizationInfoHandle authorizationInfoHandle;
    private TokenStore tokenStore;

    public CustomPreAuthenticatedUserDetailsService(UserDetailsService userDetailsService, AuthorizationInfoHandle authorizationInfoHandle, TokenStore tokenStore) {
        Assert.notNull((Object)userDetailsService, (String)"UserDetailsService cannot be null.");
        this.userDetailsService = userDetailsService;
        this.authorizationInfoHandle = authorizationInfoHandle;
        this.tokenStore = tokenStore;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"UserDetailsService must be set");
    }

    public UserDetails loadUserDetails(T authentication) throws UsernameNotFoundException {
        String refreshToken = RequestUtil.getRequestRefreshToken();
        OAuth2Authentication oAuth2Authentication = this.tokenStore.readAuthenticationForRefreshToken(this.tokenStore.readRefreshToken(refreshToken));
        OAuth2Request oAuth2Request = oAuth2Authentication.getOAuth2Request();
        String grantType = oAuth2Request.getGrantType();
        RetriveUserFunction retriveUserFunction = this.authorizationInfoHandle.obtainFunction(grantType);
        if (retriveUserFunction == null) {
            return this.userDetailsService.loadUserByUsername(authentication.getName());
        }
        return retriveUserFunction.retrive(authentication, this.userDetailsService);
    }

    public CustomPreAuthenticatedUserDetailsService() {
    }
}

