/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.extension.mobile;

import com.relaxed.oauth2.auth.extension.PreValidator;
import com.relaxed.oauth2.auth.extension.mobile.SmsCodeAuthenticationToken;
import java.util.LinkedHashMap;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.util.Assert;

public class SmsCodeTokenGranter
extends AbstractTokenGranter {
    public static final String GRANT_TYPE = "sms_code";
    private final AuthenticationManager authenticationManager;
    private final PreValidator preValidator;

    public SmsCodeTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory, AuthenticationManager authenticationManager, PreValidator preValidator) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        Assert.notNull((Object)preValidator, (String)"\u524d\u7f6e\u9a8c\u8bc1\u5668\u4e0d\u80fd\u4e3a\u7a7a-[sms_code]");
        this.authenticationManager = authenticationManager;
        this.preValidator = preValidator;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(tokenRequest.getRequestParameters());
        this.preValidator.validate(parameters);
        String mobile = (String)parameters.get("mobile");
        String code = (String)parameters.get("code");
        parameters.remove("code");
        SmsCodeAuthenticationToken userAuth = new SmsCodeAuthenticationToken(mobile, code);
        ((AbstractAuthenticationToken)userAuth).setDetails(parameters);
        try {
            userAuth = this.authenticationManager.authenticate((Authentication)userAuth);
        }
        catch (AccountStatusException exception) {
            throw new InvalidGrantException(exception.getMessage());
        }
        catch (BadCredentialsException exception) {
            throw new InvalidGrantException(exception.getMessage());
        }
        if (userAuth != null && userAuth.isAuthenticated()) {
            OAuth2Request storedOAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
            return new OAuth2Authentication(storedOAuth2Request, (Authentication)userAuth);
        }
        throw new InvalidGrantException("Could not authenticate user: " + mobile);
    }
}

