/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.extension.mobile;

import com.relaxed.oauth2.auth.extension.ExtendUserDetailsService;
import com.relaxed.oauth2.auth.extension.mobile.SmsCodeAuthenticationToken;
import java.util.HashSet;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class SmsCodeAuthenticationProvider
implements AuthenticationProvider {
    private final UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SmsCodeAuthenticationToken authenticationToken = (SmsCodeAuthenticationToken)authentication;
        String mobile = (String)authenticationToken.getPrincipal();
        UserDetails userDetails = ((ExtendUserDetailsService)this.userDetailsService).loginByMobile(mobile);
        SmsCodeAuthenticationToken result = new SmsCodeAuthenticationToken(userDetails, authentication.getCredentials(), new HashSet());
        result.setDetails(authentication.getDetails());
        return result;
    }

    public boolean supports(Class<?> authentication) {
        return SmsCodeAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public SmsCodeAuthenticationProvider(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsCodeAuthenticationProvider)) {
            return false;
        }
        SmsCodeAuthenticationProvider other = (SmsCodeAuthenticationProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserDetailsService this$userDetailsService = this.getUserDetailsService();
        UserDetailsService other$userDetailsService = other.getUserDetailsService();
        return !(this$userDetailsService == null ? other$userDetailsService != null : !this$userDetailsService.equals(other$userDetailsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsCodeAuthenticationProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserDetailsService $userDetailsService = this.getUserDetailsService();
        result = result * 59 + ($userDetailsService == null ? 43 : $userDetailsService.hashCode());
        return result;
    }

    public String toString() {
        return "SmsCodeAuthenticationProvider(userDetailsService=" + this.getUserDetailsService() + ")";
    }
}

