/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.configurer;

import cn.hutool.core.collection.CollectionUtil;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

public class CustomWebSecurityConfigurer
extends WebSecurityConfigurerAdapter {
    private final List<AuthenticationProvider> authenticationProviderList;
    private static final String AUTHORIZE_ENDPOINT_PATH = "/oauth/authorize";

    @Bean(value={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (CollectionUtil.isEmpty(this.authenticationProviderList)) {
            return;
        }
        for (AuthenticationProvider authenticationProvider : this.authenticationProviderList) {
            auth.authenticationProvider(authenticationProvider);
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).formLogin().and()).authorizeRequests().antMatchers(new String[]{AUTHORIZE_ENDPOINT_PATH})).authenticated();
    }

    public CustomWebSecurityConfigurer(List<AuthenticationProvider> authenticationProviderList) {
        this.authenticationProviderList = authenticationProviderList;
    }
}

