/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.configurer;

import com.relaxed.oauth2.auth.builder.TokenGrantBuilder;
import com.relaxed.oauth2.auth.builder.TokenServicesBuilder;
import com.relaxed.oauth2.auth.configurer.OAuth2ClientConfigurer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.CollectionUtils;

public class CustomAuthorizationServerConfigurer
extends AuthorizationServerConfigurerAdapter {
    private final OAuth2ClientConfigurer clientConfigurer;
    private final AuthenticationManager authenticationManager;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final AccessDeniedHandler accessDeniedHandler;
    private final TokenStore tokenStore;
    private final TokenGrantBuilder tokenGrantBuilder;
    private final List<TokenEnhancer> tokenEnhancerList;
    private final AccessTokenConverter accessTokenConverter;
    private final WebResponseExceptionTranslator<OAuth2Exception> webResponseExceptionTranslator;
    private final UserDetailsService userDetailsService;
    private final TokenServicesBuilder tokenServicesBuilder;

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.tokenKeyAccess("permitAll()").checkTokenAccess("isAuthenticated()").authenticationEntryPoint(this.authenticationEntryPoint).accessDeniedHandler(this.accessDeniedHandler).allowFormAuthenticationForClients().addObjectPostProcessor((ObjectPostProcessor)new ObjectPostProcessor<Object>(){

            public <O> O postProcess(O object) {
                if (object instanceof ClientCredentialsTokenEndpointFilter) {
                    ClientCredentialsTokenEndpointFilter filter = (ClientCredentialsTokenEndpointFilter)object;
                    filter.setAuthenticationEntryPoint(CustomAuthorizationServerConfigurer.this.authenticationEntryPoint);
                }
                return object;
            }
        });
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        TokenEnhancerChain enhancerChain = new TokenEnhancerChain();
        ArrayList<TokenEnhancer> delegates = new ArrayList<TokenEnhancer>();
        if (!CollectionUtils.isEmpty(this.tokenEnhancerList)) {
            delegates.addAll(this.tokenEnhancerList);
        }
        enhancerChain.setTokenEnhancers(delegates);
        endpoints.authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService).tokenStore(this.tokenStore).tokenGranter(this.tokenGrantBuilder.build(endpoints)).accessTokenConverter(this.accessTokenConverter).tokenEnhancer((TokenEnhancer)enhancerChain).exceptionTranslator(this.webResponseExceptionTranslator).tokenServices((AuthorizationServerTokenServices)this.tokenServicesBuilder.build(endpoints));
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        this.clientConfigurer.configure(clients);
    }

    public CustomAuthorizationServerConfigurer(OAuth2ClientConfigurer clientConfigurer, AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, AccessDeniedHandler accessDeniedHandler, TokenStore tokenStore, TokenGrantBuilder tokenGrantBuilder, List<TokenEnhancer> tokenEnhancerList, AccessTokenConverter accessTokenConverter, WebResponseExceptionTranslator<OAuth2Exception> webResponseExceptionTranslator, UserDetailsService userDetailsService, TokenServicesBuilder tokenServicesBuilder) {
        this.clientConfigurer = clientConfigurer;
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.accessDeniedHandler = accessDeniedHandler;
        this.tokenStore = tokenStore;
        this.tokenGrantBuilder = tokenGrantBuilder;
        this.tokenEnhancerList = tokenEnhancerList;
        this.accessTokenConverter = accessTokenConverter;
        this.webResponseExceptionTranslator = webResponseExceptionTranslator;
        this.userDetailsService = userDetailsService;
        this.tokenServicesBuilder = tokenServicesBuilder;
    }
}

