/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.configuration;

import com.relaxed.oauth2.auth.builder.TokenGrantBuilder;
import com.relaxed.oauth2.auth.builder.TokenGranterProvider;
import com.relaxed.oauth2.auth.builder.TokenServicesBuilder;
import com.relaxed.oauth2.auth.configurer.CustomAuthorizationServerConfigurer;
import com.relaxed.oauth2.auth.configurer.CustomWebSecurityConfigurer;
import com.relaxed.oauth2.auth.configurer.JdbcOauth2ClientConfigurer;
import com.relaxed.oauth2.auth.configurer.OAuth2ClientConfigurer;
import com.relaxed.oauth2.auth.exception.CustomWebResponseExceptionTranslator;
import com.relaxed.oauth2.auth.extension.ExtendUserDetailsService;
import com.relaxed.oauth2.auth.extension.PreValidator;
import com.relaxed.oauth2.auth.extension.PreValidatorHolder;
import com.relaxed.oauth2.auth.extension.captcha.CaptchaTokenGranter;
import com.relaxed.oauth2.auth.extension.mobile.SmsCodeAuthenticationProvider;
import com.relaxed.oauth2.auth.extension.mobile.SmsCodeTokenGranter;
import com.relaxed.oauth2.auth.functions.RetriveUserFunction;
import com.relaxed.oauth2.auth.handler.AuthorizationInfoHandle;
import com.relaxed.oauth2.auth.util.PasswordUtils;
import com.relaxed.oauth2.common.handler.CustomAccessDeniedHandler;
import com.relaxed.oauth2.common.handler.CustomAuthenticationEntryPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Import(value={CustomWebSecurityConfigurer.class, CustomAuthorizationServerConfigurer.class})
public class AuthorizationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TokenStore tokenStore() {
        return new InMemoryTokenStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessTokenConverter accessTokenConverter() {
        return new DefaultAccessTokenConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebResponseExceptionTranslator customWebResponseExceptionTranslator() {
        return new CustomWebResponseExceptionTranslator();
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return PasswordUtils.ENCODER;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new CustomAuthenticationEntryPoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessDeniedHandler accessDeniedHandler() {
        return new CustomAccessDeniedHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ClientConfigurer oAuth2ClientConfigurer(DataSource dataSource) {
        return new JdbcOauth2ClientConfigurer(dataSource);
    }

    @Bean
    public PreValidatorHolder preValidatorHolder(ObjectProvider<PreValidator> preValidatorProvider) {
        HashMap<String, PreValidator> preValidatorMap = new HashMap<String, PreValidator>(8);
        preValidatorProvider.forEach(e -> preValidatorMap.put(e.supportType(), (PreValidator)e));
        return new PreValidatorHolder(preValidatorMap);
    }

    private PreValidator buildDefaultValidator(final String supportType) {
        return new PreValidator(){

            @Override
            public String supportType() {
                return supportType;
            }

            @Override
            public void validate(Map<String, String> parameters) {
                throw new RuntimeException(supportType + "\u524d\u7f6e\u9a8c\u8bc1\u5668,\u672a\u81ea\u5b9a\u4e49");
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenGrantBuilder tokenGrantBuilder(AuthenticationManager authenticationManager, PreValidatorHolder preValidatorHolder) {
        TokenGranterProvider captchaTokenGranter = endpoints -> new CaptchaTokenGranter(endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory(), authenticationManager, Optional.ofNullable(preValidatorHolder.getByType("captcha")).orElseGet(() -> this.buildDefaultValidator("captcha")));
        TokenGranterProvider smsCodeTokenGranter = endpoints -> new SmsCodeTokenGranter(endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory(), authenticationManager, Optional.ofNullable(preValidatorHolder.getByType("sms_code")).orElseGet(() -> this.buildDefaultValidator("sms_code")));
        ArrayList<TokenGranterProvider> tokenGranterProviderList = new ArrayList<TokenGranterProvider>();
        tokenGranterProviderList.add(captchaTokenGranter);
        tokenGranterProviderList.add(smsCodeTokenGranter);
        TokenGrantBuilder tokenGrantBuilder = new TokenGrantBuilder(authenticationManager, tokenGranterProviderList);
        return tokenGrantBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public DaoAuthenticationProvider daoAuthenticationProvider(PasswordEncoder passwordEncoder, UserDetailsService userDetailsService) {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(userDetailsService);
        provider.setPasswordEncoder(passwordEncoder);
        return provider;
    }

    @Bean
    public SmsCodeAuthenticationProvider smsCodeAuthenticationProvider(UserDetailsService userDetailsService) {
        return new SmsCodeAuthenticationProvider(userDetailsService);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorizationInfoHandle authorizationInfoHandle() {
        return new AuthorizationInfoHandle().grantType("password", new RetriveUserFunction(){

            @Override
            public <T extends Authentication> UserDetails retrive(T authentication, UserDetailsService userDetailsService) {
                String name = authentication.getName();
                return userDetailsService.loadUserByUsername(name);
            }
        }).grantType("sms_code", new RetriveUserFunction(){

            @Override
            public <T extends Authentication> UserDetails retrive(T authentication, UserDetailsService userDetailsService) {
                String name = authentication.getName();
                ExtendUserDetailsService extendUserDetailsService = (ExtendUserDetailsService)userDetailsService;
                return extendUserDetailsService.loginByMobile(name);
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenServicesBuilder tokenServicesBuilder(UserDetailsService userDetailsService, AuthorizationInfoHandle authorizationInfoHandle, TokenStore tokenStore) {
        return new TokenServicesBuilder(userDetailsService, authorizationInfoHandle, tokenStore);
    }
}

