/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.builder;

import com.relaxed.oauth2.auth.extension.refresh.CustomPreAuthenticatedUserDetailsService;
import com.relaxed.oauth2.auth.handler.AuthorizationInfoHandle;
import java.util.Arrays;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

public class TokenServicesBuilder {
    private final UserDetailsService userDetailsService;
    private final AuthorizationInfoHandle authorizationInfoHandle;
    private final TokenStore tokenStore;

    public DefaultTokenServices build(AuthorizationServerEndpointsConfigurer endpoints) {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(endpoints.getTokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setClientDetailsService(endpoints.getClientDetailsService());
        tokenServices.setTokenEnhancer(endpoints.getTokenEnhancer());
        PreAuthenticatedAuthenticationProvider provider = new PreAuthenticatedAuthenticationProvider();
        provider.setPreAuthenticatedUserDetailsService(new CustomPreAuthenticatedUserDetailsService(this.userDetailsService, this.authorizationInfoHandle, this.tokenStore));
        tokenServices.setAuthenticationManager((AuthenticationManager)new ProviderManager(Arrays.asList(provider)));
        tokenServices.setReuseRefreshToken(false);
        return tokenServices;
    }

    public TokenServicesBuilder(UserDetailsService userDetailsService, AuthorizationInfoHandle authorizationInfoHandle, TokenStore tokenStore) {
        this.userDetailsService = userDetailsService;
        this.authorizationInfoHandle = authorizationInfoHandle;
        this.tokenStore = tokenStore;
    }
}

