/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.auth.builder;

import com.relaxed.oauth2.auth.builder.TokenGranterProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.TokenGranter;

public class TokenGrantBuilder {
    private final AuthenticationManager authenticationManager;
    private final List<TokenGranterProvider> tokenGranterProviders;

    public TokenGrantBuilder(AuthenticationManager authenticationManager) {
        this(authenticationManager, Collections.EMPTY_LIST);
    }

    public TokenGrantBuilder(AuthenticationManager authenticationManager, List<TokenGranterProvider> tokenGranterProviders) {
        this.authenticationManager = authenticationManager;
        this.tokenGranterProviders = tokenGranterProviders;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public TokenGranter build(AuthorizationServerEndpointsConfigurer endpoints) {
        List<TokenGranter> tokenGranters = this.defaultTokenGranters(endpoints);
        for (TokenGranterProvider tokenGranterProvider : this.tokenGranterProviders) {
            tokenGranters.add(tokenGranterProvider.provide(endpoints));
        }
        return new CompositeTokenGranter(tokenGranters);
    }

    protected List<TokenGranter> defaultTokenGranters(AuthorizationServerEndpointsConfigurer endpoints) {
        ArrayList<TokenGranter> granterList = new ArrayList<TokenGranter>(Arrays.asList(endpoints.getTokenGranter()));
        return granterList;
    }
}

