/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.admin.core.thread;

import cn.hutool.core.map.MapUtil;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;

public class MdcTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> {
            Map old = MDC.getCopyOfContextMap();
            try {
                if (MapUtil.isNotEmpty((Map)contextMap)) {
                    MDC.setContextMap((Map)contextMap);
                }
                runnable.run();
            }
            finally {
                if (old == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)old);
                }
            }
        };
    }
}

