/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.pool.monitor.monitor;

public class ThreadPoolStats {
    private long timestamp;
    private String poolName;
    private int activeThreads;
    private int corePoolSize;
    private int maximumPoolSize;
    private int largestPoolSize;
    private int poolSize;
    private int queueSize;
    private int queueCapacity;
    private long taskCount;
    private long completedTaskCount;
    private long rejectedCount;
    private double activeThreadRatio;
    private double queueUsageRatio;
    private double taskCompletionRatio;

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public long getRejectedCount() {
        return this.rejectedCount;
    }

    public double getActiveThreadRatio() {
        return this.activeThreadRatio;
    }

    public double getQueueUsageRatio() {
        return this.queueUsageRatio;
    }

    public double getTaskCompletionRatio() {
        return this.taskCompletionRatio;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setActiveThreads(int activeThreads) {
        this.activeThreads = activeThreads;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setLargestPoolSize(int largestPoolSize) {
        this.largestPoolSize = largestPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setTaskCount(long taskCount) {
        this.taskCount = taskCount;
    }

    public void setCompletedTaskCount(long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public void setRejectedCount(long rejectedCount) {
        this.rejectedCount = rejectedCount;
    }

    public void setActiveThreadRatio(double activeThreadRatio) {
        this.activeThreadRatio = activeThreadRatio;
    }

    public void setQueueUsageRatio(double queueUsageRatio) {
        this.queueUsageRatio = queueUsageRatio;
    }

    public void setTaskCompletionRatio(double taskCompletionRatio) {
        this.taskCompletionRatio = taskCompletionRatio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolStats)) {
            return false;
        }
        ThreadPoolStats other = (ThreadPoolStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getActiveThreads() != other.getActiveThreads()) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getLargestPoolSize() != other.getLargestPoolSize()) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.getTaskCount() != other.getTaskCount()) {
            return false;
        }
        if (this.getCompletedTaskCount() != other.getCompletedTaskCount()) {
            return false;
        }
        if (this.getRejectedCount() != other.getRejectedCount()) {
            return false;
        }
        if (Double.compare(this.getActiveThreadRatio(), other.getActiveThreadRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getQueueUsageRatio(), other.getQueueUsageRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getTaskCompletionRatio(), other.getTaskCompletionRatio()) != 0) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        return !(this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getActiveThreads();
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getLargestPoolSize();
        result = result * 59 + this.getPoolSize();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getQueueCapacity();
        long $taskCount = this.getTaskCount();
        result = result * 59 + (int)($taskCount >>> 32 ^ $taskCount);
        long $completedTaskCount = this.getCompletedTaskCount();
        result = result * 59 + (int)($completedTaskCount >>> 32 ^ $completedTaskCount);
        long $rejectedCount = this.getRejectedCount();
        result = result * 59 + (int)($rejectedCount >>> 32 ^ $rejectedCount);
        long $activeThreadRatio = Double.doubleToLongBits(this.getActiveThreadRatio());
        result = result * 59 + (int)($activeThreadRatio >>> 32 ^ $activeThreadRatio);
        long $queueUsageRatio = Double.doubleToLongBits(this.getQueueUsageRatio());
        result = result * 59 + (int)($queueUsageRatio >>> 32 ^ $queueUsageRatio);
        long $taskCompletionRatio = Double.doubleToLongBits(this.getTaskCompletionRatio());
        result = result * 59 + (int)($taskCompletionRatio >>> 32 ^ $taskCompletionRatio);
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        return result;
    }

    public String toString() {
        return "ThreadPoolStats(timestamp=" + this.getTimestamp() + ", poolName=" + this.getPoolName() + ", activeThreads=" + this.getActiveThreads() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", largestPoolSize=" + this.getLargestPoolSize() + ", poolSize=" + this.getPoolSize() + ", queueSize=" + this.getQueueSize() + ", queueCapacity=" + this.getQueueCapacity() + ", taskCount=" + this.getTaskCount() + ", completedTaskCount=" + this.getCompletedTaskCount() + ", rejectedCount=" + this.getRejectedCount() + ", activeThreadRatio=" + this.getActiveThreadRatio() + ", queueUsageRatio=" + this.getQueueUsageRatio() + ", taskCompletionRatio=" + this.getTaskCompletionRatio() + ")";
    }
}

