/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.pool.monitor.monitor;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredThreadPool
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(MonitoredThreadPool.class);
    private final String name;
    private final ThreadPoolExecutor originalExecutor;
    private long rejectedCount = 0L;
    private long lastUpdateTimeMills;

    public MonitoredThreadPool(String name, ThreadPoolExecutor executor) {
        super(executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getKeepAliveTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS, executor.getQueue(), executor.getThreadFactory(), executor.getRejectedExecutionHandler());
        this.name = name;
        this.originalExecutor = executor;
        this.lastUpdateTimeMills = System.currentTimeMillis();
        this.setRejectedExecutionHandler(new RejectedHandler(executor.getRejectedExecutionHandler()));
    }

    public ThreadPoolExecutor getOriginalExecutor() {
        return this.originalExecutor;
    }

    public long getRejectedCount() {
        return this.rejectedCount;
    }

    public long getLastUpdateTimeMills() {
        return this.lastUpdateTimeMills;
    }

    public void setLastUpdateTimeMills(long lastUpdateTimeMills) {
        this.lastUpdateTimeMills = lastUpdateTimeMills;
    }

    public String getName() {
        return this.name;
    }

    private class RejectedHandler
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler original;

        public RejectedHandler(RejectedExecutionHandler original) {
            this.original = original;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            MonitoredThreadPool.this.rejectedCount++;
            log.warn("\u7ebf\u7a0b\u6c60 [{}] \u62d2\u7edd\u4efb\u52a1\uff0c\u5f53\u524d\u62d2\u7edd\u603b\u6570: {}", (Object)MonitoredThreadPool.this.name, (Object)MonitoredThreadPool.this.rejectedCount);
            this.original.rejectedExecution(r, executor);
        }
    }
}

