/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.pool.monitor;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.relaxed.pool.monitor.annotation.ThreadPoolMonitor;
import com.relaxed.pool.monitor.monitor.MonitoredThreadPool;
import com.relaxed.pool.monitor.monitor.ThreadPoolTaskMonitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ThreadPoolMonitorEnhancer
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolMonitorEnhancer.class);
    private ThreadPoolTaskMonitor monitor;
    private ConfigurableListableBeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        this.monitor = (ThreadPoolTaskMonitor)applicationContext.getBean(ThreadPoolTaskMonitor.class);
    }

    private ThreadPoolTaskMonitor getMonitor() {
        return this.monitor;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof ThreadPoolExecutor) && !(bean instanceof ThreadPoolTaskExecutor)) {
            return bean;
        }
        try {
            ThreadPoolMonitor annotation;
            String annotationName;
            MethodMetadata methodMetadata;
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            if (beanDefinition instanceof AnnotatedBeanDefinition && (methodMetadata = this.getFactoryMethodMetaData((AnnotatedBeanDefinition)beanDefinition)).isAnnotated(annotationName = ThreadPoolMonitor.class.getName()) && (annotation = ThreadPoolMonitorEnhancer.extractAnnotation(methodMetadata)) != null) {
                ThreadPoolExecutor threadPoolExecutor = null;
                if (bean instanceof ThreadPoolExecutor) {
                    if (bean instanceof MonitoredThreadPool) {
                        MonitoredThreadPool monitoredThreadPool = (MonitoredThreadPool)bean;
                        String poolKey = StrUtil.isBlank((CharSequence)annotation.name()) ? monitoredThreadPool.getName() : annotation.name();
                        this.getMonitor().register(poolKey, monitoredThreadPool);
                    } else {
                        threadPoolExecutor = (ThreadPoolExecutor)bean;
                        bean = this.createProxiedExecutor(beanName, threadPoolExecutor, annotation);
                    }
                } else if (bean instanceof ThreadPoolTaskExecutor) {
                    ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)bean;
                    threadPoolExecutor = this.createProxiedExecutor(beanName, threadPoolTaskExecutor, annotation);
                    ReflectUtil.setFieldValue((Object)threadPoolTaskExecutor, (String)"threadPoolExecutor", (Object)threadPoolExecutor);
                    bean = threadPoolTaskExecutor;
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ebf\u7a0b\u6c60\u589e\u5f3a\u51fa\u9519,\u5f53\u524dbean\u540d\u79f0:{}", (Object)beanName, (Object)e);
        }
        return bean;
    }

    private static ThreadPoolMonitor extractAnnotation(MethodMetadata methodMetadata) {
        ThreadPoolMonitor annotation;
        if (methodMetadata instanceof StandardMethodMetadata) {
            Method method = ((StandardMethodMetadata)methodMetadata).getIntrospectedMethod();
            annotation = method.getAnnotation(ThreadPoolMonitor.class);
        } else {
            final Map attrs = methodMetadata.getAnnotationAttributes(ThreadPoolMonitor.class.getName());
            annotation = new ThreadPoolMonitor(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return ThreadPoolMonitor.class;
                }

                @Override
                public String name() {
                    return (String)attrs.get("name");
                }
            };
        }
        return annotation;
    }

    private MethodMetadata getFactoryMethodMetaData(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getFactoryMethodMetadata();
    }

    private <T extends ThreadPoolExecutor> ThreadPoolExecutor createProxiedExecutor(String beanName, T original, ThreadPoolMonitor annotation) {
        String poolKey = StrUtil.isBlank((CharSequence)annotation.name()) ? beanName : annotation.name();
        return this.getMonitor().register(poolKey, original);
    }

    private ThreadPoolExecutor createProxiedExecutor(String beanName, ThreadPoolTaskExecutor threadPoolTaskExecutor, ThreadPoolMonitor annotation) {
        String poolKey = StrUtil.isBlank((CharSequence)annotation.name()) ? beanName : annotation.name();
        ThreadPoolExecutor threadPoolExecutor = threadPoolTaskExecutor.getThreadPoolExecutor();
        final TaskDecorator taskDecorator = (TaskDecorator)ReflectUtil.getFieldValue((Object)threadPoolTaskExecutor, (String)"taskDecorator");
        final ConcurrentReferenceHashMap decoratedTaskMap = (ConcurrentReferenceHashMap)ReflectUtil.getFieldValue((Object)threadPoolTaskExecutor, (String)"decoratedTaskMap");
        MonitoredThreadPool monitoredThreadPool = new MonitoredThreadPool(poolKey, threadPoolExecutor){

            @Override
            public void execute(Runnable command) {
                Runnable decorated;
                if (taskDecorator != null) {
                    decorated = taskDecorator.decorate(command);
                    if (decorated != command) {
                        decoratedTaskMap.put((Object)decorated, (Object)command);
                    }
                } else {
                    decorated = command;
                }
                super.execute(decorated);
            }
        };
        return this.getMonitor().register(poolKey, monitoredThreadPool);
    }
}

