/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateTimeUtils {
    private static final DateTimeFormatter DTF_RFC_3399 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss+08:00").withZone(ZoneId.of("Asia/Shanghai"));

    public static Duration durationOf(LocalDateTime time) {
        if (time == null) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(LocalDateTime.now().until(time, ChronoUnit.MILLIS));
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.asLocalDateTime(date.getTime());
    }

    public static LocalDateTime asLocalDateTime(Long tsMills) {
        if (tsMills == null) {
            return null;
        }
        return Instant.ofEpochMilli(tsMills).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate asLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.asLocalDate(date.getTime());
    }

    public static LocalDate asLocalDate(Long tsMills) {
        if (tsMills == null) {
            return null;
        }
        return Instant.ofEpochMilli(tsMills).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Long asTimestamp(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Long asTimestamp(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Long asTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Instant asInstant(long timestamp) {
        if (timestamp == 0L) {
            return null;
        }
        return Instant.ofEpochMilli(timestamp);
    }

    public static Instant asInstant(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant asInstant(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant asInstant(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant();
    }

    public static int getSecondsByDay(int days) {
        if (days <= 0) {
            return 0;
        }
        long seconds = 86400L * (long)days;
        if ((long)((int)seconds) != seconds) {
            throw new IllegalArgumentException("cannot get seconds, exceed maximum days, current days is " + days);
        }
        return (int)seconds;
    }

    public static long getCurrentVersionDaily() {
        return DateTimeUtils.getVersionDaily(LocalDateTime.now());
    }

    public static long getVersionDaily(LocalDateTime dateTime) {
        return DateTimeUtils.getVersionDaily(dateTime.toLocalDate());
    }

    public static long getVersionDaily(LocalDate date) {
        return (long)date.getYear() * 10000L + (long)date.getMonthValue() * 100L + (long)date.getDayOfMonth();
    }

    public static long getCurrentVersionTimestamp() {
        return DateTimeUtils.getVersionTimestamp(LocalDateTime.now());
    }

    public static long getVersionTimestamp(LocalDateTime dateTime) {
        return DateTimeUtils.getVersionDaily(dateTime) * 1000000L + (long)(dateTime.getHour() * 10000) + (long)(dateTime.getMinute() * 100) + (long)dateTime.getSecond();
    }

    public static String stringify(long timeMills, TimeUnit upperPrecision, TimeUnit lowerPrecision) {
        if (timeMills <= 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (timeMills >= 86400000L && (upperPrecision == null || upperPrecision.ordinal() >= TimeUnit.DAYS.ordinal())) {
            sb.append(timeMills / 86400000L).append("\u5929");
            timeMills %= 86400000L;
        }
        if (!(timeMills < 3600000L || upperPrecision != null && upperPrecision.ordinal() < TimeUnit.HOURS.ordinal() || lowerPrecision != null && lowerPrecision.ordinal() > TimeUnit.HOURS.ordinal())) {
            sb.append(timeMills / 3600000L).append("\u65f6");
            timeMills %= 3600000L;
        }
        if (!(timeMills < 60000L || upperPrecision != null && upperPrecision.ordinal() < TimeUnit.MINUTES.ordinal() || lowerPrecision != null && lowerPrecision.ordinal() > TimeUnit.MINUTES.ordinal())) {
            sb.append(timeMills / 60000L).append("\u5206");
            timeMills %= 60000L;
        }
        if (!(timeMills < 1000L || upperPrecision != null && upperPrecision.ordinal() < TimeUnit.SECONDS.ordinal() || lowerPrecision != null && lowerPrecision.ordinal() > TimeUnit.SECONDS.ordinal())) {
            sb.append(timeMills / 1000L).append("\u79d2");
            timeMills %= 1000L;
        }
        if (!(timeMills <= 0L || upperPrecision != null && upperPrecision.ordinal() < TimeUnit.MILLISECONDS.ordinal() || lowerPrecision != null && lowerPrecision.ordinal() > TimeUnit.MILLISECONDS.ordinal())) {
            sb.append(timeMills).append("\u6beb\u79d2");
        }
        return sb.toString();
    }

    public static String stringify(Duration duration, TimeUnit upperPrecision, TimeUnit lowerPrecision) {
        return DateTimeUtils.stringify(duration.toMillis(), upperPrecision, lowerPrecision);
    }

    public static String stringify(long timeMills) {
        return DateTimeUtils.stringify(timeMills, null, null);
    }

    public static String format(LocalDateTime dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = pattern != null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ISO_DATE_TIME;
        return dateTime.format(formatter);
    }

    public static String simpleFormat(LocalDateTime dateTime) {
        return DateTimeUtils.format(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String rfc3339Format(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(DTF_RFC_3399);
    }
}

