/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.model;

import cn.longky.common.model.ErrorCode;
import cn.longky.common.model.KException;

public class Result<T> {
    private boolean success;
    private T data;
    private String errorCode;
    private String errorMessage;

    protected Result() {
    }

    protected Result(boolean success) {
        this.success = success;
    }

    public Result<T> withError(ErrorCode errorCode) {
        return this.withError(errorCode.getCode(), errorCode.getMessage());
    }

    public Result<T> withThrowable(Throwable throwable) {
        KException exception = KException.tryWrapUnknown(throwable);
        return this.withError(exception.getErrorCode(), exception.getMessage());
    }

    public Result<T> withError(String errorCode, String errorMsg) {
        this.setSuccess(false);
        this.setErrorCode(errorCode);
        this.setErrorMessage(errorMsg);
        return this;
    }

    public Result<T> withSuccess(T result) {
        this.setSuccess(true);
        this.setData(result);
        return this;
    }

    public static <T> Result<T> ofSuccess(T result) {
        return new Result<T>().withSuccess(result);
    }

    public static <T> Result<T> ofError(ErrorCode errorCode) {
        return new Result<T>().withError(errorCode);
    }

    public static <T> Result<T> ofError(String errorCode, String errorMsg) {
        return new Result<T>().withError(errorCode, errorMsg);
    }

    public static <T> Result<T> ofThrowable(Throwable t) {
        return new Result<T>().withThrowable(t);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Result<T> setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Result<T> setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "Result(success=" + this.isSuccess() + ", data=" + this.getData() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ")";
    }
}

