/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.model;

import cn.longky.common.model.ErrorCode;
import cn.longky.common.model.KRuntimeException;

public class KException
extends Exception {
    private final String errorCode;

    public KException(ErrorCode errorCode) {
        this(errorCode.getCode(), errorCode.getMessage());
    }

    public KException(ErrorCode errorCode, Throwable cause) {
        this(errorCode.getCode(), errorCode.getMessage(), cause);
    }

    public KException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public KException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public KRuntimeException toRuntime() {
        return new KRuntimeException(this);
    }

    public KException tryWrap(Throwable t) {
        if (t instanceof KException) {
            return (KException)t;
        }
        if (t instanceof KRuntimeException) {
            return ((KRuntimeException)t).getCause();
        }
        if (t.getCause() instanceof KException) {
            return (KException)t.getCause();
        }
        if (t.getCause() instanceof KRuntimeException) {
            return ((KRuntimeException)t.getCause()).getCause();
        }
        this.initCause(t);
        return this;
    }

    public String getCauseMessage() {
        return this.getCause() != null ? this.getCause().getMessage() : this.getMessage();
    }

    public static KException tryWrapUnknown(Throwable throwable) {
        return new KException("UNKNOWN", String.format("\u5185\u90e8\u9519\u8bef(%s): %s", throwable.getClass().getName(), throwable.getMessage())).tryWrap(throwable);
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

