/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.model;

import cn.longky.common.model.ErrorCode;
import cn.longky.common.model.KException;
import cn.longky.common.model.KRuntimeException;
import cn.longky.common.model.Result;
import cn.longky.common.utils.StringUtils;

public abstract class BizErrorCode
implements ErrorCode {
    public <T> Result<T> toResult() {
        return Result.ofError(this.getCode(), this.getMessage());
    }

    public <T> Result<T> toResult(String message) {
        if (message == null) {
            return this.toResult();
        }
        return Result.ofError(this.getCode(), message);
    }

    public <T> Result<T> toResult(String fmt, Object ... args) {
        return this.toResult(StringUtils.format(fmt, args));
    }

    public KException toException() {
        return new KException(this.getMessage(), this.getMessage());
    }

    public KException toException(String message) {
        if (message == null) {
            return this.toException();
        }
        return new KException(this.getCode(), message);
    }

    public KException toException(String fmt, Object ... args) {
        return this.toException(StringUtils.format(fmt, args));
    }

    public KException toException(Throwable t) {
        return this.toException().tryWrap(t);
    }

    public KRuntimeException toRuntimeException() {
        return this.toException().toRuntime();
    }

    public KRuntimeException toRuntimeException(String message) {
        return this.toException(message).toRuntime();
    }

    public KRuntimeException toRuntimeException(String fmt, Object ... args) {
        return this.toException(fmt, args).toRuntime();
    }

    public void assertTrue(boolean condition) throws KException {
        if (!condition) {
            throw this.toException();
        }
    }

    public void assertTrue(boolean condition, String message) throws KException {
        if (!condition) {
            throw this.toException(message);
        }
    }

    public void assertTrue(boolean condition, String fmt, Object ... args) throws KException {
        if (!condition) {
            throw this.toException(fmt, args);
        }
    }
}

