package cn.longky.common.utils;

import java.util.*;
import java.util.function.Function;

/**
 * @author yingzhan
 * @since 1.0
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {

    private static final char COMMA = ',';

    public static String[] commaSplit(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }

        return split(s, COMMA);
    }

    public static <T> List<T> commaSplit(String s, Function<String, T> converter) {
        if (s == null || s.isEmpty()) {
            return null;
        }

        String[] arr = commaSplit(s);
        if (arr == null) {
            return null;
        }

        return ConvertUtils.convert(Arrays.asList(arr), converter);
    }

    public static String commaJoin(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }

        return String.join(",", collection);
    }

    public static <T> String commaJoin(Collection<T> collection, Function<T, String> converter) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }

        if (converter == null) {
            converter = Objects::toString;
        }

        return String.join(",", ConvertUtils.convert(collection, converter));
    }

    public static String format(String msg, Object... args) {
        if (msg == null) {
            return null;
        }

        StringBuilder sb = new StringBuilder();
        boolean openBrace = false;
        int ai = 0;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if ('{' == ch) {
                openBrace = true;
            } else if ('}' == ch && openBrace) {
                openBrace = false;
                if (args.length > ai) {
                    sb.append(args[ai++]);
                }
            } else if (!openBrace) {
                sb.append(ch);
            }
        }
        return sb.toString();
    }
}
