package cn.longky.common.utils;

import cn.longky.common.model.KException;
import cn.longky.common.reflection.KInvocationHandler;
import cn.longky.common.reflection.KMethodInterceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;

/**
 * utilities relating to Java reflection
 *
 * @author yingzhan
 * @since 1.0
 */
public class ReflectionUtils {

    public static <T> T newProxy(Class<T> interfaceType, Object target, List<KMethodInterceptor> interceptors) {
        InvocationHandler handler = new KInvocationHandler(target, interceptors);
        if (!interfaceType.isInterface()) {
            throw new KException("UNKNOWN", interfaceType + " is not a interface").toRuntime();
        }
        Object obj = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(obj);
    }
}
