package cn.longky.common.reflection;

import lombok.RequiredArgsConstructor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/**
 * @author yingzhan
 * @since 1.0
 */
@RequiredArgsConstructor
public class KInvocationHandler implements InvocationHandler {

    private final Object target;

    private final List<KMethodInterceptor> interceptors;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return new CustomMethodInvocation(proxy, method, args).proceed();
    }

    class CustomMethodInvocation implements KMethodInvocation {

        private final Object proxy;

        private final Method method;

        private final Object[] args;

        private final int index;

        private CustomMethodInvocation(Object proxy, Method method, Object[] args, int index) {
            this.proxy = proxy;
            this.method = method;
            this.args = args;
            this.index = index;
        }

        private CustomMethodInvocation(Object proxy, Method method, Object[] args) {
            this(proxy, method, args, 0);
        }

        @Override
        public Object proceed() throws Throwable {
            if (index >= interceptors.size()) {
                try {
                    return method.invoke(target, args);
                } catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            return interceptors.get(index).invoke(new CustomMethodInvocation(proxy, method, args, index + 1));
        }

        @Override
        public Object[] getArguments() {
            return args;
        }

        @Override
        public Method getMethod() {
            return method;
        }

        @Override
        public Object getThis() {
            return target;
        }
    }
}
