package cn.longky.common.model;

import lombok.Data;

/**
 * 分页查询参数
 *
 * @author yingzhan
 * @since 1.0
 */
@Data
public class PageQuery {

    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_PAGE_NUM = 1;
    public static final int MAX_PAGE_SIZE = 100;

    public PageQuery() {}

    public PageQuery(int pageSize, int pageNum) {
        this.pageSize = pageSize;
        this.pageNum = pageNum;
    }

    public PageQuery(int pageSize) {
        this.pageSize = pageSize;
        this.pageNum = 1;
    }

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 页码
     */
    private Integer pageNum;

    public Integer getPageSize() {
        if (pageSize == null || pageSize <= 0 || pageSize > MAX_PAGE_SIZE) {
            return DEFAULT_PAGE_SIZE;
        }

        return pageSize;
    }

    public Integer getPageNum() {
        if (pageNum == null || pageNum <= 0) {
            return DEFAULT_PAGE_NUM;
        }

        return pageNum;
    }
}
