package cn.longky.common.model;

import lombok.Data;

import java.util.List;

/**
 * 分页信息
 *
 * @author yingzhan
 * @since 1.0
 */
@Data
public class PageInfo<T> {

    /**
     * 当前页
     */
    private Integer pageNum;

    /**
     * 每页大小
     */
    private Integer pageSize;

    /**
     * 总记录数
     */
    private Long total;

    /**
     * 数据列表
     */
    private List<T> list;

    private PageInfo() {
    }

    public static <T> PageInfo<T> of() {
        return new PageInfo<>();
    }

    public static <T> PageInfo<T> of(List<T> list) {
        return of(1, list.size(), list.size(), list);
    }

    public static <T> PageInfo<T> of(PageInfo<? extends T> copyPageInfo) {
        return of(copyPageInfo.getPageNum(), copyPageInfo.getPageSize(), copyPageInfo.getTotal());
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize) {
        return of(pageNum, pageSize, pageSize);
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize, long total) {
        return of(pageNum, pageSize, total, null);
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize, long total, List<T> list) {
        PageInfo<T> pageInfo = new PageInfo<>();
        pageInfo.pageNum = pageNum;
        pageInfo.pageSize = pageSize;
        pageInfo.total = total;
        pageInfo.list = list;
        return pageInfo;
    }

}