package cn.longky.common.model;

import lombok.Getter;

/**
 * 服务异常
 *
 * @author yingzhan
 * @since 1.0
 */
@Getter
public class KException extends Exception {

    /**
     * 错误码
     *
     * @see ErrorCode
     */
    private final String errorCode;

    public KException(ErrorCode errorCode) {
        this(errorCode.getCode(), errorCode.getMessage());
    }

    public KException(ErrorCode errorCode, Throwable cause) {
        this(errorCode.getCode(), errorCode.getMessage(), cause);
    }

    public KException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public KException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public KRuntimeException toRuntime() {
        return new KRuntimeException(this);
    }

    public KException tryWrap(Throwable t) {
        if (t instanceof KException) {
            return (KException) t;
        }

        if (t instanceof KRuntimeException) {
            return ((KRuntimeException) t).getCause();
        }

        if (t.getCause() instanceof KException) {
            return (KException) t.getCause();
        }

        if (t.getCause() instanceof KRuntimeException) {
            return ((KRuntimeException) t.getCause()).getCause();
        }

        initCause(t);
        return this;
    }

    public String getCauseMessage() {
        return getCause() != null ? getCause().getMessage() : getMessage();
    }

    public static KException tryWrapUnknown(Throwable throwable) {
        return new KException("UNKNOWN", String.format("内部错误(%s): %s", throwable.getClass().getName(), throwable.getMessage()))
                .tryWrap(throwable);
    }
}
