package cn.longky.common.model;

import cn.longky.common.utils.StringUtils;

/**
 * 业务错误码
 *
 * @author yingzhan
 * @since 2024/4/13
 */
public abstract class BizErrorCode implements ErrorCode {

    public <T> Result<T> toResult() {
        return Result.ofError(getCode(), getMessage());
    }

    public <T> Result<T> toResult(String message) {
        if (message == null) {
            return toResult();
        }

        return Result.ofError(getCode(), message);
    }

    public <T> Result<T> toResult(String fmt, Object... args) {
        return toResult(StringUtils.format(fmt, args));
    }

    public KException toException() {
        return new KException(getMessage(), getMessage());
    }

    public KException toException(String message) {
        if (message == null) {
            return toException();
        }
        return new KException(getCode(), message);
    }

    public KException toException(String fmt, Object... args) {
        return toException(StringUtils.format(fmt, args));
    }

    public KException toException(Throwable t) {
        return toException().tryWrap(t);
    }

    public KRuntimeException toRuntimeException() {
        return toException().toRuntime();
    }

    public KRuntimeException toRuntimeException(String message) {
        return toException(message).toRuntime();
    }

    public KRuntimeException toRuntimeException(String fmt, Object... args) {
        return toException(fmt, args).toRuntime();
    }

    public void assertTrue(boolean condition) throws KException {
        if (!condition) {
            throw toException();
        }
    }

    public void assertTrue(boolean condition, String message) throws KException {
        if (!condition) {
            throw toException(message);
        }
    }

    public void assertTrue(boolean condition, String fmt, Object... args) throws KException {
        if (!condition) {
            throw toException(fmt, args);
        }
    }
}
