package cn.longky.common.model;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author yingzhan
 * @since 1.0
 */
@SuppressWarnings({"unchecked", "rawtypes"})
@Data
public abstract class BaseEntity<T extends BaseEntity> {

    /**
     * 自增主键
     */
    protected Long id;

    /**
     * 创建时间
     */
    protected LocalDateTime createTime;

    /**
     * 修改时间
     */
    protected LocalDateTime updateTime;

    public T setId(Long id) {
        this.id = id;
        return (T) this;
    }

    public T setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return (T) this;
    }

    public T setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return (T) this;
    }
}