package cn.longky.common.model;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yingzhan
 * @since 1.0
 */
@SuppressWarnings({"rawtypes", "unchecked"})
@Data
public abstract class AttributiveEntity<T extends AttributiveEntity> extends BaseEntity<T> {

    private Map<String, Object> attributes;

    public T addAttribute(String key, Object value) {
        if (attributes == null) {
            attributes = new HashMap<>();
        }
        attributes.put(key, value);
        return (T) this;
    }

    public <U> U getAttribute(String key, Class<U> clazz) {
        if (attributes == null) {
            return null;
        }
        return clazz.cast(attributes.get(key));
    }

    public <U> U getAttribute(String key, Class<U> clazz, U defaultValue) {
        if (attributes == null) {
            return defaultValue;
        }

        U value = clazz.cast(attributes.get(key));
        if (value == null) {
            return defaultValue;
        }

        return value;
    }
}
