package cn.longky.common.handler;

import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

/**
 * StringList类型转换
 *
 * @author yingzhan
 * @since 1.0
 */
public class StringListTypeHandler extends BaseTypeHandler<List<String>> {

    private static final String DELIMITER = ",";

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        String value = String.join(DELIMITER, parameter);
        ps.setString(i, value);
    }

    @Override
    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return getStringList(rs.getString(columnName));
    }

    @Override
    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return getStringList(rs.getString(columnIndex));
    }

    @Override
    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return getStringList(cs.getString(columnIndex));
    }

    private List<String> getStringList(String columnValue) throws SQLException {
        if (columnValue == null) {
            return null;
        }

        try {
            return Arrays.asList(columnValue.split(DELIMITER));
        } catch (Exception e) {
            throw new SQLException("convert to string list error, columnValue = " + columnValue);
        }
    }
}
