package cn.longky.common.function;

/**
 * Represents a supplier of results.
 *
 * <p>There is no requirement that a new or distinct result be returned each
 * time the supplier is invoked.
 *
 * <p>This is a functional interface
 * whose functional method is {@link #get()}.
 *
 * @param <T> the type of results supplied by this supplier
 *
 * @author yingzhan
 * @since 1.0
 */
@FunctionalInterface
public interface KSupplier<T> {

    /**
     * Gets a result.
     *
     * @return a result
     * @throws Exception if exception occurs
     */
    T get() throws Exception;
}
