package cn.longky.common.function;

import cn.longky.common.model.KException;

/**
 * The {@link KRunnable} interface should be implemented by any
 * class whose instances are intended to be executed by a thread. The
 * class must define a method of no arguments called <code>run</code>.
 * <p>
 * This interface is designed to provide a common protocol for objects that
 * wish to execute code while they are active.
 *
 * @author yingzhan
 * @since 1.0
 */
@FunctionalInterface
public interface KRunnable {

     /**
     * When an object implementing interface {@link KRunnable} is used
     * to create a thread, starting the thread causes the object's
     * <code>run</code> method to be called in that separately executing
     * thread.
     * <p>
     * The general contract of the method <code>run</code> is that it may
     * take any action whatsoever.
     *
     * @throws KException if exception occurs
     */
    void run() throws KException;
}
