package cn.longky.common.function;


/**
 * @author yingzhan
 * @since 1.0
 */
@FunctionalInterface
public interface KConsumer<T> {

    /**
     * Performs this operation on the given argument.
     *
     * @param t the input argument
     * @throws Exception custom exception
     */
    void accept(T t) throws Exception;

    /**
     * Returns a composed {@code Consumer} that performs, in sequence, this
     * operation followed by the {@code after} operation. If performing either
     * operation throws an exception, it is relayed to the caller of the
     * composed operation.  If performing this operation throws an exception,
     * the {@code after} operation will not be performed.
     *
     * @param after the operation to perform after this operation
     * @return a composed {@code Consumer} that performs in sequence this
     * operation followed by the {@code after} operation
     */
    default KConsumer<T> andThen(KConsumer<? super T> after) {
        return (T t) -> { accept(t); after.accept(t); };
    }
}
