/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.validation.validator;

import cn.longky.common.validation.constraint.Phone;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneValidator
implements ConstraintValidator<Phone, CharSequence> {
    private static final int LOCAL_PART_LENGTH = 11;
    private static final Pattern LOCAL_PART_PATTERN = Pattern.compile("^1[3-9]\\d{9}+$");

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        Matcher matcher = LOCAL_PART_PATTERN.matcher(value);
        return value.length() == 11 && matcher.matches();
    }
}

