/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.reflection;

import cn.longky.common.reflection.KMethodInterceptor;
import cn.longky.common.reflection.KMethodInvocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class KInvocationHandler
implements InvocationHandler {
    private final Object target;
    private final List<KMethodInterceptor> interceptors;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return new CustomMethodInvocation(proxy, method, args).proceed();
    }

    public KInvocationHandler(Object target, List<KMethodInterceptor> interceptors) {
        this.target = target;
        this.interceptors = interceptors;
    }

    class CustomMethodInvocation
    implements KMethodInvocation {
        private final Object proxy;
        private final Method method;
        private final Object[] args;
        private final int index;

        private CustomMethodInvocation(Object proxy, Method method, Object[] args, int index) {
            this.proxy = proxy;
            this.method = method;
            this.args = args;
            this.index = index;
        }

        private CustomMethodInvocation(Object proxy, Method method, Object[] args) {
            this(proxy, method, args, 0);
        }

        @Override
        public Object proceed() throws Throwable {
            if (this.index >= KInvocationHandler.this.interceptors.size()) {
                try {
                    return this.method.invoke(KInvocationHandler.this.target, this.args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            return KInvocationHandler.this.interceptors.get(this.index).invoke(new CustomMethodInvocation(this.proxy, this.method, this.args, this.index + 1));
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object getThis() {
            return KInvocationHandler.this.target;
        }
    }
}

