/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.model;

import java.util.List;

public class PageInfo<T> {
    private Integer pageNum;
    private Integer pageSize;
    private Long total;
    private List<T> list;

    private PageInfo() {
    }

    public static <T> PageInfo<T> of() {
        return new PageInfo<T>();
    }

    public static <T> PageInfo<T> of(List<T> list) {
        return PageInfo.of(1, list.size(), list.size(), list);
    }

    public static <T> PageInfo<T> of(PageInfo<? extends T> copyPageInfo) {
        return PageInfo.of(copyPageInfo.getPageNum(), copyPageInfo.getPageSize(), copyPageInfo.getTotal());
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize) {
        return PageInfo.of(pageNum, pageSize, pageSize);
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize, long total) {
        return PageInfo.of(pageNum, pageSize, total, null);
    }

    public static <T> PageInfo<T> of(int pageNum, int pageSize, long total, List<T> list) {
        PageInfo<T> pageInfo = new PageInfo<T>();
        pageInfo.pageNum = pageNum;
        pageInfo.pageSize = pageSize;
        pageInfo.total = total;
        pageInfo.list = list;
        return pageInfo;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getList() {
        return this.list;
    }

    public PageInfo<T> setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public PageInfo<T> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PageInfo<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    public PageInfo<T> setList(List<T> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageInfo(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", list=" + this.getList() + ")";
    }
}

