/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class StringMapTypeHandler
extends BaseTypeHandler<Map<String, Object>> {
    private static final TypeReference<Map<String, Object>> TR = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper JSON = new ObjectMapper();

    public void setNonNullParameter(PreparedStatement ps, int i, Map<String, Object> parameter, JdbcType jdbcType) throws SQLException {
        try {
            String value = JSON.writeValueAsString(parameter);
            ps.setString(i, value);
        }
        catch (Exception e) {
            throw new SQLException("convert from string map error, parameter = " + parameter);
        }
    }

    public Map<String, Object> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getStringMap(rs.getString(columnName));
    }

    public Map<String, Object> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getStringMap(rs.getString(columnIndex));
    }

    public Map<String, Object> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getStringMap(cs.getString(columnIndex));
    }

    private Map<String, Object> getStringMap(String columnValue) throws SQLException {
        if (columnValue == null) {
            return null;
        }
        try {
            return (Map)JSON.readValue(columnValue, TR);
        }
        catch (Exception e) {
            throw new SQLException("convert to string map error, columnValue = " + columnValue);
        }
    }
}

