/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.utils;

import cn.longky.common.utils.ConvertUtils;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public static Iterable<String> commaSplit(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return COMMA_SPLITTER.split((CharSequence)s);
    }

    public static <T> List<T> commaSplit(String s, Function<String, T> converter) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return ConvertUtils.convert(Lists.newArrayList(StringUtils.commaSplit(s)), converter);
    }

    public static String commaJoin(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", collection);
    }

    public static <T> String commaJoin(Collection<T> collection, Function<T, String> converter) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (converter == null) {
            converter = Objects::toString;
        }
        return String.join((CharSequence)",", ConvertUtils.convert(collection, converter));
    }

    public static String format(String msg, Object ... args) {
        if (msg == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean openBrace = false;
        int ai = 0;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if ('{' == ch) {
                openBrace = true;
                continue;
            }
            if ('}' == ch && openBrace) {
                openBrace = false;
                if (args.length <= ai) continue;
                sb.append(args[ai++]);
                continue;
            }
            if (openBrace) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String indent(String s, int indentSize) {
        if (s == null || indentSize <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (ch == '\n') {
                sb.append('\n').append(Strings.repeat((String)"\t", (int)indentSize));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

