/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.utils;

import java.util.regex.Pattern;

public class NumericUtils {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("[+-]?\\d+(\\.\\d+)?");

    public static Long asLong(Number n) {
        if (n == null) {
            return null;
        }
        return n.longValue();
    }

    public static Integer asInt(Number n) {
        if (n == null) {
            return null;
        }
        if ((long)n.intValue() == n.longValue()) {
            return n.intValue();
        }
        throw new NumberFormatException("Not an integer: " + n);
    }

    public static Short asShort(Number n) {
        if (n == null) {
            return null;
        }
        if (n.shortValue() == n.intValue()) {
            return n.shortValue();
        }
        throw new NumberFormatException("Not an short: " + n);
    }

    public static int toInt(String str) {
        return NumericUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumericUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumericUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumericUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static byte toByte(String str) {
        return NumericUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumericUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        return NUMERIC_PATTERN.matcher(s).matches();
    }
}

