/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.utils;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ConvertUtils {
    public static <T extends Enum<T>> T convert(String name, Class<T> clazz) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <T extends Enum<T>> T convert(Integer ordinal, Class<T> clazz) {
        if (ordinal == null) {
            return null;
        }
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        if (ordinal >= 0 && ordinal < enums.length) {
            return (T)enums[ordinal];
        }
        return null;
    }

    public static <S, T extends Enum<T>> T convert(S source, Class<T> clazz, Function<T, S> sourceGetter) {
        if (source == null) {
            return null;
        }
        for (Enum enumConstant : (Enum[])clazz.getEnumConstants()) {
            if (!Objects.equals(sourceGetter.apply(enumConstant), source)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public static <T extends Enum<T>> Integer convert2Int(String name, Class<T> clazz) {
        T t = ConvertUtils.convert(name, clazz);
        return t != null ? Integer.valueOf(((Enum)t).ordinal()) : null;
    }

    public static <T extends Enum<T>> String convert2String(Integer ordinal, Class<T> clazz) {
        T t = ConvertUtils.convert(ordinal, clazz);
        return t != null ? ((Enum)t).name() : null;
    }

    public static <S, T> List<T> convert(Collection<S> sources, Function<S, T> converter) {
        if (sources == null || converter == null) {
            return null;
        }
        return sources.stream().map(converter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <U, V, T extends Collection<U>, R extends Collection<V>> R convert(T t, Supplier<R> initializer, Function<U, V> converter) {
        if (t == null) {
            return null;
        }
        Collection r = (Collection)initializer.get();
        for (U u : t) {
            Object v = null;
            try {
                v = converter.apply(u);
            }
            finally {
                if (v == null) continue;
                r.add(v);
            }
        }
        return (R)r;
    }
}

