/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.utils;

import cn.longky.common.function.KRunnable;
import cn.longky.common.function.KSupplier;
import cn.longky.common.model.KException;
import cn.longky.common.utils.StringUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class CommonUtils {
    private static final Random RANDOM = new Random();
    private static final char[] CHARS = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static <T> T safeCast(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return (T)o;
        }
        if (clazz == Long.class) {
            if (o instanceof Integer) {
                return clazz.cast((Integer)o);
            }
            if (o instanceof Byte) {
                return clazz.cast((Byte)o);
            }
            if (o instanceof Character) {
                return clazz.cast(((Character)o).charValue());
            }
            if (o instanceof Double) {
                return clazz.cast((long)((Double)o).doubleValue());
            }
            if (o instanceof Float) {
                return clazz.cast((long)((Float)o).floatValue());
            }
        } else if (clazz == Integer.class) {
            if (o instanceof Long) {
                return clazz.cast((int)((Long)o).longValue());
            }
            if (o instanceof Byte) {
                return clazz.cast((Byte)o);
            }
            if (o instanceof Character) {
                return clazz.cast(((Character)o).charValue());
            }
            if (o instanceof Double) {
                return clazz.cast((int)((Double)o).doubleValue());
            }
            if (o instanceof Float) {
                return clazz.cast((int)((Float)o).floatValue());
            }
        }
        return null;
    }

    @SafeVarargs
    @NonNull
    public static <T> T firstNonnull(T ... args) {
        for (T t : args) {
            if (t == null) continue;
            return t;
        }
        throw new IllegalArgumentException("Arguments cannot be all nullable.");
    }

    @SafeVarargs
    public static <T> T firstNonnull(T defaultValue, Supplier<T> ... suppliers) {
        for (Supplier<T> supplier : suppliers) {
            T t;
            if (supplier == null || (t = supplier.get()) == null) continue;
            return t;
        }
        return defaultValue;
    }

    @SafeVarargs
    public static <T> T firstMatch(@NonNull Function<T, Boolean> matcher, T ... args) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        for (T t : args) {
            if (!matcher.apply(t).booleanValue()) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T firstMatchWithSuppliers(@NonNull Function<T, Boolean> matcher, Supplier<T> ... suppliers) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        for (Supplier<T> supplier : suppliers) {
            T t;
            if (supplier == null || !matcher.apply(t = supplier.get()).booleanValue()) continue;
            return t;
        }
        return null;
    }

    public static <T> T swallowException(KSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void swallowException(KRunnable runnable) {
        try {
            runnable.run();
        }
        catch (KException kException) {
            // empty catch block
        }
    }

    public static String getUuid() {
        return CommonUtils.getUuid("");
    }

    public static String getUuid(String replacement) {
        String uuid = UUID.randomUUID().toString();
        if (replacement == null) {
            return uuid;
        }
        return uuid.replace("-", replacement);
    }

    @SafeVarargs
    public static <T> boolean contains(T item, T ... array) {
        if (array.length == 0 || item == null) {
            return false;
        }
        for (T t : array) {
            if (!Objects.equals(t, item)) continue;
            return true;
        }
        return false;
    }

    public static String encryptPassword(@NonNull String password, @NonNull String salt) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        String raw = password + salt;
        return DigestUtils.sha256Hex((String)raw);
    }

    public static boolean validatePassword(String rawPassword, String encryptedPassword, String salt) {
        if (StringUtils.isBlank((CharSequence)rawPassword) || StringUtils.isBlank((CharSequence)encryptedPassword) || StringUtils.isBlank((CharSequence)salt)) {
            return false;
        }
        return encryptedPassword.equals(CommonUtils.encryptPassword(rawPassword, salt));
    }

    public static String generateRandomString(int length, boolean isNumeric, boolean ignoreCase) {
        int charLength;
        if (length <= 0) {
            throw new IllegalArgumentException("\u751f\u6210\u7684\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u662f\u6b63\u6574\u6570");
        }
        if (isNumeric) {
            return RandomStringUtils.randomNumeric((int)length);
        }
        StringBuilder sb = new StringBuilder(length);
        int n = charLength = ignoreCase ? 32 : CHARS.length;
        while (length-- > 0) {
            int idx = RANDOM.nextInt(charLength);
            sb.append(CHARS[idx]);
        }
        return sb.toString();
    }

    public static String generateUniqueCodeByUid(long userId, int length, boolean isNumeric, int primeOfCharLength, long salt) {
        int i;
        if (length < 4) {
            throw new IllegalArgumentException("\u6240\u751f\u6210\u7684\u76ee\u6807\u7801\u957f\u5ea6\u4e0d\u80fd\u5c11\u4e8e4");
        }
        long uid = userId * (long)primeOfCharLength + salt;
        char[] codes = new char[length];
        int[] ids = new int[length];
        int charLength = isNumeric ? 9 : CHARS.length;
        for (i = 0; i < length; ++i) {
            ids[i] = (int)(uid % (long)charLength);
            ids[i] = (ids[i] + i * ids[0]) % charLength;
            uid /= (long)charLength;
        }
        for (i = 0; i < length; ++i) {
            int idx = i * (length - 1) % length;
            codes[i] = CHARS[ids[idx]];
        }
        return new String(codes);
    }

    public static String generateUniqueCodeByUid(long userId, int length, boolean isNumeric) {
        return CommonUtils.generateUniqueCodeByUid(userId, length, isNumeric, 23, 123456789L);
    }

    public static String stringifySize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("\u5c3a\u5bf8\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        StringBuilder sb = new StringBuilder();
        if (size >= 0x4000000000000L) {
            sb.append(size / 0x4000000000000L).append("PB");
            size %= 0x4000000000000L;
        }
        if (size >= 0x10000000000L) {
            sb.append(size / 0x10000000000L).append("TB");
            size %= 0x10000000000L;
        }
        if (size >= 0x40000000L) {
            sb.append(size / 0x40000000L).append("GB");
            size %= 0x40000000L;
        }
        if (size >= 0x100000L) {
            sb.append(size / 0x100000L).append("MB");
            size %= 0x100000L;
        }
        if (size >= 1024L) {
            sb.append(size / 1024L).append("KB");
            size %= 1024L;
        }
        if (size > 0L) {
            sb.append(size).append("B");
        }
        return sb.toString();
    }

    public static <T> T retry(@NonNull KSupplier<T> supplier, int maxRetries, Duration sleepTime, Class<? extends Throwable> throwableClass, Predicate<T> verifier) throws Throwable {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        while (maxRetries-- > 0) {
            block6: {
                try {
                    T t = supplier.get();
                    if (maxRetries <= 0 || verifier == null || verifier.test(t)) {
                        return t;
                    }
                }
                catch (Throwable t) {
                    if (maxRetries <= 0) {
                        throw t;
                    }
                    if (throwableClass == null || throwableClass.isInstance(t)) break block6;
                    throw t;
                }
            }
            if (sleepTime == null) continue;
            Thread.sleep(sleepTime.toMillis());
        }
        return null;
    }

    public static Long parseLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof CharSequence) {
            return Long.parseLong(((CharSequence)o).toString());
        }
        throw new NumberFormatException();
    }

    public static Integer parseInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof CharSequence) {
            return Integer.parseInt(((CharSequence)o).toString());
        }
        throw new NumberFormatException();
    }

    public static Boolean parseBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof CharSequence) {
            String s = ((CharSequence)o).toString();
            return "true".equalsIgnoreCase(s) || "1".equals(s);
        }
        throw new NumberFormatException();
    }
}

