/*
 * Decompiled with CFR 0.152.
 */
package cn.longky.common.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class StringListTypeHandler
extends BaseTypeHandler<List<String>> {
    private static final String DELIMITER = ",";

    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        String value = String.join((CharSequence)DELIMITER, parameter);
        ps.setString(i, value);
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getStringList(rs.getString(columnName));
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getStringList(rs.getString(columnIndex));
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getStringList(cs.getString(columnIndex));
    }

    private List<String> getStringList(String columnValue) throws SQLException {
        if (columnValue == null) {
            return null;
        }
        try {
            return Arrays.asList(columnValue.split(DELIMITER));
        }
        catch (Exception e) {
            throw new SQLException("convert to string list error, columnValue = " + columnValue);
        }
    }
}

