/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.json;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u5e8f\u5217\u5316\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <T> T toBean(String json, Class<T> tClass) {
        try {
            return (T)JSON.parseObject((String)json, tClass);
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <T> List<T> toList(String json, Class<T> tClass) {
        try {
            return JSON.parseArray((String)json, tClass, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)JSON.parseObject((String)json, Map.class);
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }
}

