/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.json;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);
    public static final ObjectMapper mapper = new ObjectMapper();

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error(MessageFormat.format("Json\u5e8f\u5217\u5316\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", new Object[]{e}));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <T> T toBean(String json, Class<T> tClass) {
        try {
            return (T)mapper.readValue(json, tClass);
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <T> T toList(String json, Class<T> tClass) {
        try {
            return (T)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, tClass));
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Json\u89e3\u6790\u51fa\u9519\uff0c\u9519\u8bef\u5185\u5bb9{0}", e));
            throw new SnowException(CommonExceptionEnum.JSON_PARSING_ERROR);
        }
    }
}

