/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.ip;

import cn.lonelysnow.common.utils.call.ApiCallUtils;
import com.alibaba.fastjson2.JSONObject;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String LOCAL_IP = "127.0.0.1";
    public static final String UNKNOWN = "XX XX";
    public static final String IP_QUERY_URL = "https://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true";

    public static String getIpAddr(HttpServletRequest request) {
        String unknown = "unknown";
        if (request == null) {
            return unknown;
        }
        String ip = request.getHeader("X-Real-IP");
        if (StringUtils.isBlank((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? LOCAL_IP : ip;
    }

    public static String getLocationByIp(String ip) {
        if (IpUtils.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            String rspStr = ApiCallUtils.doGetResJson(String.format(IP_QUERY_URL, ip));
            if (StringUtils.isEmpty((CharSequence)rspStr)) {
                log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38\uff1a{}", (Object)ip);
                return UNKNOWN;
            }
            JSONObject obj = JSONObject.parseObject((String)rspStr);
            String region = obj.getString("pro");
            String city = obj.getString("city");
            String addr = obj.getString("addr");
            if (StringUtils.isEmpty((CharSequence)region) && StringUtils.isEmpty((CharSequence)city)) {
                return StringUtils.isNotBlank((CharSequence)addr) ? addr.trim() : UNKNOWN;
            }
            return String.format("%s %s", region, city);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38", (Throwable)e);
            return UNKNOWN;
        }
    }

    public static boolean internalIp(String ip) {
        byte[] ipBytes = IpUtils.textToNumericFormatV4(ip);
        return IpUtils.isLocalIp(ip) || IpUtils.internalIp(ipBytes);
    }

    public static byte[] textToNumericFormatV4(String text) {
        if (text.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[4];
        String[] elements = text.split("\\.", -1);
        try {
            switch (elements.length) {
                case 1: {
                    long l = Long.parseLong(elements[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    bytes[0] = (byte)(l >> 24 & 0xFFL);
                    bytes[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(elements[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    bytes[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(elements[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    bytes[1] = (byte)(l >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(elements[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    bytes[2] = (byte)(l >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return bytes;
    }

    public static boolean isLocalIp(String ip) {
        return LOCAL_IP.equals(ip) || "0:0:0:0:0:0:0:1".equals(ip);
    }

    private static boolean internalIp(byte[] ipBytes) {
        if (Objects.isNull(ipBytes) || ipBytes.length < 2) {
            return true;
        }
        byte b0 = ipBytes[0];
        byte b1 = ipBytes[1];
        int section1 = 10;
        int section2 = -84;
        int section3 = 16;
        int section4 = 31;
        int section5 = -64;
        int section6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                if (b1 != -88) break;
                return true;
            }
        }
        return false;
    }

    private IpUtils() {
    }
}

